#include "CMRControllerMgr.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csf/logger/CSFLogger.hpp"
#include "jcfcoreutils/StringUtils.h"
#include "csfunified/services/impl/BaseToImplCast.h"
#include "services/interface/CMRMeetingCallback.h"
#include "../MeetingServiceImpl.h"
//#include "InstantMessageMgr.h"
//#include "MeetingApiDelegate.h"
#include "jcfcoreutils/FunctionTask.h"
#include "csfunified/framework/ServicesDispatcher.h"
#include "csfunified/framework/FunctorTask.h"
#include "boost/bind.hpp"
#include "../MeetingServiceObjectManager.h"
#include "../JabberServiceProvider.h"



namespace CSFUnified
{
	static CSFLogger* JabberCMRControllerMgrLogger = CSFLogger_getLogger("MeetingService-JabberCMRControllerMgr");

	CMRControllerMgr::CMRControllerMgr(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
	{
        m_unifiedFactory = unifiedFactory;
	}
		
	CMRControllerMgr::~CMRControllerMgr()
	{
	}

	void CMRControllerMgr::start()
	{
        bool isEnable = isCMREnable();
        CSFLogInfoS(JabberCMRControllerMgrLogger, "CMRControllerMgr::start() isCMREnable = " << isEnable);

        SMART_PTR_NS::shared_ptr<MeetingServiceImpl> meetingService = baseToImplCast<MeetingService, MeetingServiceImpl>(m_unifiedFactory->getService<MeetingService>());
        meetingService->setIsCMREnabled(isEnable);
		meetingService->fireIsCMREnabled();
	}

	void CMRControllerMgr::stop()
	{
		CSFLogInfoS(JabberCMRControllerMgrLogger, "CMRControllerMgr::stop()");
		m_mapCMRCtrl.clear();
	}

    SMART_PTR_NS::shared_ptr<CMRControllerImpl> CMRControllerMgr::getCMRController(const std::string JID)
    {
        SMART_PTR_NS::shared_ptr<CMRControllerImpl> obj;
        
        //lock
        std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.find(JID);
        if (it != m_mapCMRCtrl.end())
        {
            obj = it->second;
        }
        else
        {
            CMRControllerImpl * impl = new CMRControllerImpl(m_unifiedFactory, JID);
            obj.reset(impl);
            m_mapCMRCtrl[JID] = obj;
            
            if (isCMREnable())
            {
                obj->setCMRProperty(m_property);
            }
            else
            {
                obj->clearCMRProperty();
            }
        }
        
        //unlock
        
        return obj;
    }

    void CMRControllerMgr::onPMRPropertyChange(bool isSendNotice, bool isCMREnable, CMRProperty& property)
	{
		//lock
		m_property = property;
		if (isCMREnable)
		{
			CSFLogInfoS(JabberCMRControllerMgrLogger, "CMRControllerMgr::onPMRPropertyChange()"
				<< " isCMR = " << property.isCMR
				<< ", isPMR = " << property.isPMR);
		}

		std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.begin();
		while (it != m_mapCMRCtrl.end())
		{
			SMART_PTR_NS::shared_ptr<CMRControllerImpl> obj = it->second;
            if (isCMREnable)
			{
				obj->setCMRProperty(property);
			}
			else
			{
				obj->clearCMRProperty();
			}
			it++;
		}

        csf::ScopedReadRWLock lock(mLock);
        bool isOnDispatcher = m_unifiedFactory->getServicesDispatcher()->checkForUpdateAccess();
        if(isOnDispatcher)
        {
            fireCMRProertyChange(this->isCMREnable(), isSendNotice);
        }
        else
        {
            m_unifiedFactory->getServicesDispatcher()->enqueueBlock(boost::bind(&CMRControllerMgr::fireCMRProertyChange, this, this->isCMREnable(), isSendNotice), "CMRControllerMgr::fireCMRProertyChange");
        }
    }
	
	void CMRControllerMgr::registerCallback(SMART_PTR_NS::shared_ptr<CMRMeetingCallback> callback)
	{
		bool isAdd = false;

		std::list<SMART_PTR_NS::shared_ptr<CMRMeetingCallback> >::iterator it = m_listCallback.begin();
		while (it != m_listCallback.end())
		{
			SMART_PTR_NS::shared_ptr<CMRMeetingCallback> obj = *it;
			if (obj == callback)
			{
				isAdd = true;
				break;
			}
			it++;
		}

		if (!isAdd)
		{
			m_listCallback.push_back(callback);
		}
	}

	void CMRControllerMgr::unregisterCallback(SMART_PTR_NS::shared_ptr<CMRMeetingCallback> callback)
	{
		//lock
		std::list<SMART_PTR_NS::shared_ptr<CMRMeetingCallback> >::iterator it = m_listCallback.begin();
		while (it != m_listCallback.end())
		{
			SMART_PTR_NS::shared_ptr<CMRMeetingCallback> obj = *it;
			if (obj == callback)
			{
				m_listCallback.erase(it);
				break;
			}

			it++;
		}
		//unlock
	}
	
	void CMRControllerMgr::sendMeetingStarted(CMRMeetingErrorCodeEnum::CMRMeetingErrorCode errCode, std::string JID)
	{
		//lock
		
		do
		{
			std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.find(JID);
			if (it == m_mapCMRCtrl.end())
			{
				break;
			}

			SMART_PTR_NS::shared_ptr<CMRControllerImpl> ptr = it->second;
			std::list<SMART_PTR_NS::shared_ptr<CMRMeetingCallback> >::iterator it2 = m_listCallback.begin();
			while (it2 != m_listCallback.end())
			{
				(*it2)->onMeetingStarted(errCode, ptr);
				it2++;
			}
			
			sendMeetingInvitationToLagecyClient(ptr->getJID(), ptr->getjoinUrl(), ptr->getsipUrl());

		} while (0);

		//unlock
	}

	void CMRControllerMgr::sendMeetingJoined(CMRMeetingErrorCodeEnum::CMRMeetingErrorCode errCode, std::string JID)
	{
		//lock

		do
		{
			std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.find(JID);
			if (it == m_mapCMRCtrl.end())
			{
				break;
			}

			SMART_PTR_NS::shared_ptr<CMRControllerImpl> ptr = it->second;
			std::list<SMART_PTR_NS::shared_ptr<CMRMeetingCallback> >::iterator it2 = m_listCallback.begin();
			while (it2 != m_listCallback.end())
			{
				(*it2)->onMeetingJoined(errCode, ptr);
				it2++;
			}
		} while (0);

		//unlock
	}

	void CMRControllerMgr::sendMeetingEnded(std::string JID)
	{
		//lock

		do
		{
			std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.find(JID);
			if (it == m_mapCMRCtrl.end())
			{
				break;
			}

			SMART_PTR_NS::shared_ptr<CMRControllerImpl> ptr = it->second;
			std::list<SMART_PTR_NS::shared_ptr<CMRMeetingCallback> >::iterator it2 = m_listCallback.begin();
			while (it2 != m_listCallback.end())
			{
				(*it2)->onMeetingEnded(ptr);
				it2++;
			}
		} while (0);

		//unlock
	}

	void CMRControllerMgr::onCmrMeetingStarted(const CMRMeetingData& info)
	{
        std::string JID = "";
        
		//lock
		std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.begin();
		while (it != m_mapCMRCtrl.end())
		{
			SMART_PTR_NS::shared_ptr<CMRControllerImpl> obj = it->second;
			if (obj->onCmrMeetingStarted(info))
			{
				JID = obj->getJID();
				break;
			}
			it++;
		}
		//unlock

		sendMeetingStarted(CMRMeetingErrorCodeEnum::CMR_SUCCESS, JID);
	}

	void CMRControllerMgr::onCmrMeetingJoined()
	{
		std::string JID = "";

		//lock
		std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.begin();
		while (it != m_mapCMRCtrl.end())
		{
			SMART_PTR_NS::shared_ptr<CMRControllerImpl> obj = it->second;
			if (obj->onCmrMeetingJoined())
			{
				JID = obj->getJID();
				break;
			}
			it++;
		}
		//unlock

		sendMeetingJoined(CMRMeetingErrorCodeEnum::CMR_SUCCESS, JID);
	}

	void CMRControllerMgr::onCmrMeetingError()
	{
		bool isHost;
		std::string JID = "";

		//lock
		std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.begin();
		while (it != m_mapCMRCtrl.end())
		{
			SMART_PTR_NS::shared_ptr<CMRControllerImpl> obj = it->second;
			if (obj->onCmrMeetingError(isHost))
			{
				JID = obj->getJID();
				break;
			}
			it++;
		}
		//unlock

		if (isHost)
		{
			sendMeetingStarted(CMRMeetingErrorCodeEnum::CMR_FAILED_COMMON_ERROR, JID);
		}
		else
		{
			sendMeetingJoined(CMRMeetingErrorCodeEnum::CMR_FAILED_COMMON_ERROR, JID);
		}
	}

	void CMRControllerMgr::onCmrMeetingEnded()
	{
		std::string JID = "";

		//lock
		std::map<std::string, SMART_PTR_NS::shared_ptr<CMRControllerImpl> >::iterator it = m_mapCMRCtrl.begin();
		while (it != m_mapCMRCtrl.end())
		{
			SMART_PTR_NS::shared_ptr<CMRControllerImpl> obj = it->second;
			if (obj->onCmrMeetingEnded())
			{
				JID = obj->getJID();
				break;
			}
			it++;
		}
		//unlock

		sendMeetingEnded(JID);
	}

	bool CMRControllerMgr::isCMREnable()
	{
		return m_property.isCMR;
	}
    
    void CMRControllerMgr::fireCMRProertyChange(bool isCMREnable, bool isSendNotice)
    {
        CSFLogInfoS(JabberCMRControllerMgrLogger, "CMRControllerMgr::fireCMRProertyChange()" << " isCMR = " << isCMREnable << "isSendNotice " << isSendNotice);
        
        SMART_PTR_NS::shared_ptr<MeetingServiceImpl> meetingService = baseToImplCast<MeetingService, MeetingServiceImpl>(m_unifiedFactory->getService<MeetingService>());
        meetingService->setIsCMREnabled(isCMREnable);
        if (isSendNotice)
        {
            meetingService->fireIsCMREnabled();
        }
    }

	void CMRControllerMgr::sendMeetingInvitationToLagecyClient(std::string JID, std::string joinUrl, std::string sipUrl)
	{
        std::string cmdMsg = "Empty";
        std::string htmlMsg = "{%1} invites you to a conference. Click {%2} to join by call, or click {%3} to join in WebEx.";
        std::string plainMsg = "{%1} invites you to a conference. Click {%2} to join by call, or click {%3} to join in WebEx.";
        
        std::string plantSipUrl = sipUrl;
        std::string htmlSipUrl = "<a href = \"tel:" + plantSipUrl + "\">" + "tel:" + plantSipUrl + "</a>";
        std::string plantJoinUrl = encodeURL(joinUrl);
        std::string htmlJoinUrl = "a href=" + plantJoinUrl + ">here</a>";
        std::string strMyDisplayName = MeetingServiceObjectManager::getInstance().getJabberServiceProvider()->getMyDisplayName();
        
        JCFCoreUtils::replaceAll(htmlMsg, "{%3}", htmlJoinUrl);
        JCFCoreUtils::replaceAll(htmlMsg, "{%2}", htmlSipUrl);
        JCFCoreUtils::replaceAll(htmlMsg, "{%1}", strMyDisplayName);
        
        JCFCoreUtils::replaceAll(plainMsg, "{%3}", plantJoinUrl);
        JCFCoreUtils::replaceAll(plainMsg, "{%2}", plantSipUrl);
        JCFCoreUtils::replaceAll(plainMsg, "{%1}", strMyDisplayName);
        
        MeetingServiceObjectManager::getInstance().getJabberServiceProvider()->SendCmd_CMRMeetingInvitation(JID, cmdMsg, htmlMsg, plainMsg);
	}

	std::string CMRControllerMgr::encodeURL(std::string url)
	{
        std::string ret = "";
		const char* h = "0123456789abcdef";

		for (std::size_t i = 0; i < url.size(); i++)
		{
			char c = url[i];

			if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') || (c == '/') || (c == '.') || (c == ':'))
			{
				ret += c;
			}
			else
			{
				ret += '%';
				ret += h[(c & 0xf0) >> 4];
				ret += h[c & 0x0f];
			}
		}

		return ret;
	}
}
